/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceList;
import com.ibm.hsc.auiml.databeans.updates.SystemInfoBean;
import com.ibm.hsc.websm.updates.AdvFeaturesTasklet;
import com.ibm.hsc.websm.updates.ChangeInternalCodeTasklet;
import com.ibm.hsc.websm.updates.FirmwareUpdateConstants;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hsc.websm.updates.PIUpdateableComponent;
import com.ibm.hsc.websm.updates.SurveyAndImportHandler;
import com.ibm.hsc.websm.updates.SysInfoEcData;
import com.ibm.hsc.websm.updates.SysInfoEcInternalCodeData;
import com.ibm.hsc.websm.updates.SysInfoLevelData;
import com.ibm.hsc.websm.updates.UpdatePanelUtilities;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.List;

public class SysInfoTasklet
extends HwmcaPanelTasklet
implements FirmwareUpdateConstants,
PIUpdateErrorIds {
    private static final String TRACE_MASKT = "XUPDSITT";
    private static final String TRACE_MASKF = "XUPDSITF";
    private static final String TRACE_MASKD = "XUPDSITD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-53, "SysInfoTasklet");
    PanelTasklet parentTasklet;
    private ManagedObject targetCurrentlyProcessing;
    private MediaServicesUtil savedMediaServUtil = null;
    private RepositoryItem reposItem;

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysInfoTasklet.service()");
        Trace.trace((String)TRACE_MASKT, (Object)("PanelTaskletRequest = " + panelTaskletRequest));
        String string = (String)panelTaskletRequest.getData("command");
        if (panelTaskletRequest.isInitialRequest()) {
            PresentationTaskParms presentationTaskParms;
            this.showBusyDialog(new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "SYSTEM_INFORMATION_TITLE"), new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PLEASE_WAIT_GATHERING_INFO"));
            Trace.trace((String)TRACE_MASKT, (Object)"SysInfoTasklet PanelTaskletRequest = InitialRequest");
            this.parentTasklet = this.getParent();
            this.reposItem = this.parentTasklet instanceof ChangeInternalCodeTasklet ? ((ChangeInternalCodeTasklet)this.parentTasklet).getRepositoryItem() : ((AdvFeaturesTasklet)this.parentTasklet).getRepositoryItem();
            if (null == this.reposItem) {
                Trace.trace((String)TRACE_MASKD, (Object)" [SysInfoTasklet.service()] got null for repository item");
            }
            if ((presentationTaskParms = this.parentTasklet.getPresentationTaskParms()) != null) {
                int n;
                block35: {
                    SystemInfoBean systemInfoBean;
                    ObjectId[] objectIdArray = presentationTaskParms.getTargetIds();
                    Trace.trace((String)TRACE_MASKD, (Object)(" [SysInfoTasklet.service()] number of targets: " + objectIdArray.length));
                    boolean bl = true;
                    n = this.reposItem.getReposType();
                    if (n == 1) {
                        this.savedMediaServUtil = new MediaServicesUtil((PanelTasklet)this);
                        systemInfoBean = this.getMediaDevice(this.savedMediaServUtil, 6, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "CHANGE_INT_CODE_TITLE"), false);
                        if (null != systemInfoBean) {
                            try {
                                this.reposItem.setLocation(systemInfoBean.getMountPoint().getAbsolutePath());
                            }
                            catch (MediaDeviceException mediaDeviceException) {
                                Trace.trace((String)TRACE_MASKT, (Object)(" [SysInfoTasklet.service()] caught exception: " + (Object)((Object)mediaDeviceException)));
                                bl = false;
                                try {
                                    this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD8001"), new MessageText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD0016"), null, null);
                                }
                                catch (TaskletException taskletException) {
                                    Trace.trace((String)TRACE_MASKF, (Object)" [SysInfoTasklet.service()] Exception working with message box!");
                                }
                            }
                        } else {
                            bl = false;
                        }
                    }
                    if (bl) {
                        try {
                            int n2;
                            if (objectIdArray.length == 1) {
                                Trace.trace((String)TRACE_MASKD, (Object)" [SysInfoTasklet.service()] Handle single target case.");
                                this.targetCurrentlyProcessing = (ManagedObject)this.getObjectForId(objectIdArray[0]);
                                systemInfoBean = this.getSystemInfoBean(this.targetCurrentlyProcessing, this.reposItem);
                                systemInfoBean.setBeanName("SystemInfoSingle");
                                panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.updates.FirmwareRes", "SystemInfo1Panel", (PanelBean)systemInfoBean);
                                break block35;
                            }
                            Trace.trace((String)TRACE_MASKD, (Object)" [SysInfoTasklet.service()] Handle multiple targets case.");
                            systemInfoBean = new SystemInfoBean();
                            systemInfoBean.setBeanName("SystemInfoFrameBean");
                            DisplayAreaDescriptorData displayAreaDescriptorData = new DisplayAreaDescriptorData("com.ibm.hsc.auiml.databeans.updates.FirmwareRes", "SystemInfoTPanel", (PanelBean)systemInfoBean, null, "The Frame");
                            DisplayAreaDescriptorDelegate[] displayAreaDescriptorDelegateArray = new DisplayAreaDescriptorDelegate[objectIdArray.length];
                            for (n2 = 0; n2 < objectIdArray.length; ++n2) {
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                hashMap.put("sysInfoRepos", this.reposItem);
                                ObjectId objectId = objectIdArray[n2];
                                this.targetCurrentlyProcessing = (ManagedObject)this.getObjectForId(objectId);
                                SystemInfoBean systemInfoBean2 = this.getSystemInfoBean(this.targetCurrentlyProcessing, this.reposItem);
                                systemInfoBean2.setBeanName("SysInfoTab" + n2);
                                hashMap.put("sysInfoBean", systemInfoBean2);
                                displayAreaDescriptorDelegateArray[n2] = new DisplayAreaDescriptorDelegate("com.ibm.hsc.websm.updates.SysInfoEcTasklet", hashMap);
                                displayAreaDescriptorDelegateArray[n2].setMountPoint("MountPointTPane");
                            }
                            Trace.trace((String)TRACE_MASKF, (Object)("Number of panes to display is " + n2));
                            panelTaskletResponse.replace(displayAreaDescriptorData, (DisplayAreaDescriptor[])displayAreaDescriptorDelegateArray);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Trace.trace((String)TRACE_MASKF, (Object)(" Caught exception: " + illegalArgumentException));
                            this.logException(illegalArgumentException);
                            panelTaskletResponse.terminate();
                        }
                        catch (HException hException) {
                            Trace.trace((String)TRACE_MASKT, (Object)(" [SysInfoTasklet.service()] Caught exception: " + (Object)((Object)hException)));
                            Trace.trace((String)TRACE_MASKD, (Object)(" [SysInfoTasklet.service()] target that failed: " + this.targetCurrentlyProcessing.getUIInfo().getName()));
                            this.releaseMediaDeviceLock();
                            if (hException instanceof PIUpdateException) {
                                MessageText messageText = ((PIUpdateException)hException).getMessageText();
                                try {
                                    this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD8004"), messageText, MsgType.ERROR_MESSAGE, null);
                                }
                                catch (TaskletException taskletException) {
                                    Trace.trace((String)TRACE_MASKF, (Object)" [SysInfoTasklet.service()] Exception working with message box!");
                                }
                            } else {
                                try {
                                    this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD8004"), new MessageText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD0004", (Object[])new String[]{this.targetCurrentlyProcessing.getUIInfo().getName()}), null, null);
                                }
                                catch (TaskletException taskletException) {
                                    Trace.trace((String)TRACE_MASKF, (Object)" [SysInfoTasklet.service()] Exception working with message box for generic msg!");
                                }
                            }
                            Trace.trace((String)TRACE_MASKT, (Object)" [SysInfoTasklet.service()] Terminate task due to nonrecoverable error.");
                            panelTaskletResponse.terminate();
                        }
                    } else {
                        Trace.trace((String)TRACE_MASKT, (Object)" [SysInfoTasklet.service()] Terminate task due to error with DVD media.");
                        panelTaskletResponse.terminate();
                    }
                }
                if (n == 1) {
                    this.releaseMediaDeviceLock();
                    this.reposItem.setLocation(null);
                }
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"PresentationTaskParms is null");
                HException hException = new HException("PresentationTaskParms is null");
                new FrameworkLog(logInfo, -1574, (Throwable)hException).log();
                Trace.trace((String)TRACE_MASKT, (Object)" [SysInfoTasklet.service()] Terminate task since PresentationTaskParms is null.");
                panelTaskletResponse.terminate();
            }
            this.destroyBusyDialog();
        } else if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
            Trace.trace((String)TRACE_MASKT, (Object)" [SysInfoTasklet.service()] Terminate task because the panel is being disposed.");
            panelTaskletResponse.terminate();
        } else if (string.equalsIgnoreCase("ViewIoButton")) {
            SurveyAndImportHandler surveyAndImportHandler = SurveyAndImportHandler.getSurveyAndImportHandler();
            ResourceList resourceList = surveyAndImportHandler.getEntireIOSurvey();
            if (null != resourceList && resourceList.size() > 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("repos", this.reposItem);
                hashMap.put("targets", null);
                hashMap.put("survey", resourceList);
                hashMap.put("readonly", "true");
                DisplayAreaDescriptorDelegate displayAreaDescriptorDelegate = new DisplayAreaDescriptorDelegate("com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsTasklet", hashMap);
                panelTaskletResponse.openModalChild(displayAreaDescriptorDelegate);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)" [SysInfoTasklet.service()] Can't get ResourceList to pass to I/O tasklet. Tell user there are no details to show.");
                try {
                    this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD8001"), new MessageText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD0010"), null, null);
                }
                catch (TaskletException taskletException) {
                    Trace.trace((String)TRACE_MASKF, (Object)" [SysInfoTasklet.service()] Exception working with message box!");
                }
                panelTaskletResponse.noAction();
            }
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)" [SysInfoTasklet.service()] Ignore Action: none of our specified actions");
            panelTaskletResponse.noAction();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysInfoTasklet.service()");
    }

    private SystemInfoBean getSystemInfoBean(ManagedObject managedObject, RepositoryItem repositoryItem) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysInfoTasklet.getSystemInfoBean()");
        LocalizableText localizableText = new LocalizableText(managedObject.getUIInfo().getName());
        Trace.trace((String)TRACE_MASKD, (Object)(" [getSystemInfoBean()] Displayable name = " + localizableText));
        SysInfoEcInternalCodeData sysInfoEcInternalCodeData = this.getSysInfoData(managedObject, repositoryItem);
        Trace.trace((String)TRACE_MASKF, (Object)" [getSystemInfoBean()] Got SysInfoData.");
        SystemInfoBean systemInfoBean = new SystemInfoBean(localizableText, sysInfoEcInternalCodeData);
        int n = repositoryItem.getReposType();
        if (n != 1 && n != 4 && n != 0) {
            systemInfoBean.setIoButtonStatus(false);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysInfoTasklet.getSystemInfoBean()");
        return systemInfoBean;
    }

    private SysInfoEcInternalCodeData getSysInfoData(ManagedObject managedObject, RepositoryItem repositoryItem) throws HException {
        boolean bl;
        Trace.trace((String)TRACE_MASKT, (Object)"->SysInfoTasklet.getSysInfoData()");
        ObjectId objectId = managedObject.getObjectId();
        SysInfoEcInternalCodeData sysInfoEcInternalCodeData = new SysInfoEcInternalCodeData(objectId);
        sysInfoEcInternalCodeData.setTargetName(managedObject.getUIInfo().getName());
        sysInfoEcInternalCodeData.setTargetMTMS(UpdatePanelUtilities.getPIOwnerForManagedObject(managedObject).getCECMTMS());
        int n = repositoryItem.getReposType();
        LocalizableText localizableText = UpdatePanelUtilities.getRepositoryLocationText(n);
        sysInfoEcInternalCodeData.setRepositoryLocation(localizableText.toString());
        if (n == -1) {
            sysInfoEcInternalCodeData.setHideColumns(true);
        }
        List list = UpdatePanelUtilities.doSurvey(managedObject, repositoryItem, true);
        boolean bl2 = true;
        String string = "";
        LocalizableText localizableText2 = list.iterator();
        while (localizableText2.hasNext()) {
            PIUpdateableComponent pIUpdateableComponent = (PIUpdateableComponent)localizableText2.next();
            SysInfoEcData sysInfoEcData = new SysInfoEcData();
            sysInfoEcData.setEcNumber(pIUpdateableComponent.getECNumber());
            sysInfoEcData.setEcType(pIUpdateableComponent.getName());
            sysInfoEcData.setEcMTMS(pIUpdateableComponent.getMTMS());
            SysInfoLevelData sysInfoLevelData = new SysInfoLevelData(pIUpdateableComponent.getStagableLevel());
            SysInfoLevelData sysInfoLevelData2 = new SysInfoLevelData(pIUpdateableComponent.getNonDisruptiveStagableLevel());
            SysInfoLevelData sysInfoLevelData3 = new SysInfoLevelData(pIUpdateableComponent.getApplyInProgressLevel());
            SysInfoLevelData sysInfoLevelData4 = new SysInfoLevelData(pIUpdateableComponent.getAppliedLevel());
            SysInfoLevelData sysInfoLevelData5 = new SysInfoLevelData(pIUpdateableComponent.getCommittedLevel());
            sysInfoEcData.setRetrievableLevelData(sysInfoLevelData);
            sysInfoEcData.setRetrievableconcurrentLevelData(sysInfoLevelData2);
            sysInfoEcData.setInstalledLevelData(sysInfoLevelData3);
            sysInfoEcData.setActivatedLevelData(sysInfoLevelData4);
            sysInfoEcData.setAcceptedLevelData(sysInfoLevelData5);
            sysInfoEcInternalCodeData.addSysInfoEcData(sysInfoEcData);
            sysInfoEcInternalCodeData.setEcValid(true);
            Trace.trace((String)TRACE_MASKF, (Object)("   SysInfoTasklet.getSysInfoData() - EC number is: " + pIUpdateableComponent.getECNumber() + ", LIC type is: " + pIUpdateableComponent.getName() + ", MTMS is: " + pIUpdateableComponent.getMTMS()));
            Trace.trace((String)TRACE_MASKF, (Object)("    stageable level is '" + sysInfoLevelData.getLevel() + "', " + "non-disruptive stageable level is '" + sysInfoLevelData2.getLevel() + "', " + "apply in progress level is '" + sysInfoLevelData3.getLevel() + "', "));
            Trace.trace((String)TRACE_MASKF, (Object)("    applied level is '" + sysInfoLevelData4.getLevel() + "', " + "committed level is '" + sysInfoLevelData5.getLevel() + "'"));
            if (!bl2 || pIUpdateableComponent.isConcurrentUpdatingEnabled()) continue;
            bl2 = false;
            string = pIUpdateableComponent.getUpdatingDisabledReason().toString();
            Trace.trace((String)TRACE_MASKF, (Object)(" [getSysInfoData()] Component '" + pIUpdateableComponent.getName() + "' is disabled for concurrent updates: " + string));
        }
        if (bl2) {
            bl = false;
            localizableText2 = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "ENABLED_TEXT");
        } else {
            bl = true;
            localizableText2 = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "DISABLED_TEXT");
        }
        sysInfoEcInternalCodeData.setUpdateDisabled(bl);
        sysInfoEcInternalCodeData.setUpdateStatus(localizableText2.toString());
        sysInfoEcInternalCodeData.setDisableReason(string);
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysInfoTasklet.getSysInfoData()");
        return sysInfoEcInternalCodeData;
    }

    public void destroy() {
        Trace.trace((String)TRACE_MASKF, (Object)"<> SysInfoTasklet.destroy()");
        this.releaseMediaDeviceLock();
    }

    private MediaDevice getMediaDevice(MediaServicesUtil mediaServicesUtil, int n, LocalizableText localizableText, boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysInfoTasklet.getMediaDevice()");
        MediaDevice mediaDevice = null;
        try {
            mediaDevice = mediaServicesUtil.prepareMedia(n, localizableText, bl, null);
        }
        catch (MediaServicesUtilException mediaServicesUtilException) {
            Trace.trace((String)TRACE_MASKT, (Object)(" [getMediaDevice()] caught exception: " + (Object)((Object)mediaServicesUtilException)));
            Trace.trace((String)TRACE_MASKT, (Object)(" [getMediaDevice()] The exception type is: " + Integer.toString(mediaServicesUtilException.getErrorType())));
            if (mediaServicesUtilException.getErrorType() != 11) {
                try {
                    this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD8001"), new MessageText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD0016"), null, null);
                }
                catch (TaskletException taskletException) {
                    Trace.trace((String)TRACE_MASKF, (Object)" [getMediaDevice()] Exception working with message box!");
                }
            }
            this.releaseMediaDeviceLock();
        }
        if (null == mediaDevice) {
            Trace.trace((String)TRACE_MASKD, (Object)" [getMediaDevice()] returning NULL for media device.");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysInfoTasklet.getMediaDevice()");
        return mediaDevice;
    }

    private void releaseMediaDeviceLock() {
        if (null != this.savedMediaServUtil) {
            try {
                Trace.trace((String)TRACE_MASKD, (Object)" [SysInfoTasklet.releaseMediaDeviceLock()] Releasing media device lock.");
                this.savedMediaServUtil.releaseMedia();
            }
            catch (MediaServicesUtilException mediaServicesUtilException) {
                // empty catch block
            }
            this.savedMediaServUtil = null;
        }
    }

    public void logException(Throwable throwable) {
        new FrameworkLog(logInfo, -1575, throwable).log();
    }
}

